implementation module StdTimerElementClass


//	Version 1.0

//	Definition of the TimerElements class for timer elements with and without local state.


import	StdList
import	StdIOCommon, StdTimerDef
import	timerhandle


class TimerElements t
where
	timerElementToHandles	:: !(t .ls .ps) -> [TimerElementState .ls .ps]
	getTimerElementType		::	(t .ls .ps) -> TimerElementType

instance TimerElements (AddLS t)	| TimerElements t
where
	timerElementToHandles	:: !(AddLS t .ls .ps) -> [TimerElementState .ls .ps]	| TimerElements t
	timerElementToHandles {addLS,addDef}
	=	[TimerElementHandleToTimerElementState 
			(TimerExtendLSHandle {	tExtendLS		= addLS
								 ,	tExtendItems	= map TimerElementStateToTimerElementHandle (timerElementToHandles addDef)
								 }
			)
		]
	
	getTimerElementType :: (AddLS t .ls .ps) -> TimerElementType	| TimerElements t
	getTimerElementType _ = ""
instance TimerElements (NewLS t)	| TimerElements t
where
	timerElementToHandles	:: !(NewLS t .ls .ps) -> [TimerElementState .ls .ps]	| TimerElements t
	timerElementToHandles {newLS,newDef}
	=	[TimerElementHandleToTimerElementState 
			(TimerChangeLSHandle {	tChangeLS		= newLS
								 ,	tChangeItems	= map TimerElementStateToTimerElementHandle (timerElementToHandles newDef)
								 }
			)
		]
	
	getTimerElementType :: (NewLS t .ls .ps) -> TimerElementType	| TimerElements t
	getTimerElementType _ = ""
instance TimerElements (ListLS t)	| TimerElements t
where
	timerElementToHandles	:: !(ListLS t .ls .ps) -> [TimerElementState .ls .ps]	| TimerElements t
	timerElementToHandles (ListLS t)
	=	[TimerElementHandleToTimerElementState 
			(TimerListLSHandle (map TimerElementStateToTimerElementHandle (flatten (map timerElementToHandles t))))
		]
	
	getTimerElementType :: (ListLS t .ls .ps) -> TimerElementType	| TimerElements t
	getTimerElementType _ = ""
instance TimerElements NilLS
where
	timerElementToHandles	:: !(NilLS .ls .ps) -> [TimerElementState .ls .ps]
	timerElementToHandles NilLS
	=	[TimerElementHandleToTimerElementState (TimerListLSHandle [])]
	
	getTimerElementType :: (NilLS .ls .ps) -> TimerElementType
	getTimerElementType _ = ""
instance TimerElements ((:+:) t1 t2)	| TimerElements t1 & TimerElements t2
where
	timerElementToHandles :: !((:+:) t1 t2 .ls .ps) -> [TimerElementState .ls .ps]	| TimerElements t1 & TimerElements t2
	timerElementToHandles (t1:+:t2)
	=	timerElementToHandles t1 ++ timerElementToHandles t2
	
	getTimerElementType :: ((:+:) t1 t2 .ls .ps) -> TimerElementType	| TimerElements t1 & TimerElements t2
	getTimerElementType _ = ""
